/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.HashMap;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.services.ServiceUnavailableException;
import sun.plugin.util.Trace;

final class SmartProxyHandler
implements ProxyHandler {
    private ProxyHandler realHandler = null;
    private HashMap proxyCache = new HashMap();
    private int pingTimeout;
    private long aliveTimeout;
    private long deadTimeout;

    public boolean isProxyCacheSupported() {
        return this.realHandler.isProxyCacheSupported();
    }

    public boolean isSupported(int n) {
        return this.realHandler.isSupported(n);
    }

    public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        this.realHandler.init(browserProxyInfo);
    }

    public SmartProxyHandler(ProxyHandler proxyHandler) {
        this.proxyCache.put(new ProxyInfo(null, -1), new ProxyRecord(this, true, -1L));
        AccessController.doPrivileged(new PrivilegedAction(this){
            private final SmartProxyHandler this$0;

            public Object run() {
                SmartProxyHandler.access$002(this.this$0, Integer.getInteger("javaplugin.proxy.pingTimeout", 2000));
                SmartProxyHandler.access$102(this.this$0, Long.getLong("javaplugin.proxy.aliveTimeout", 1800000L));
                SmartProxyHandler.access$202(this.this$0, Long.getLong("javaplugin.proxy.deadTimeout", 600000L));
                return null;
            }
            {
                this.this$0 = smartProxyHandler;
            }
        });
        this.realHandler = proxyHandler;
    }

    private boolean pingProxy(ProxyInfo proxyInfo) {
        String string = proxyInfo.getProxy();
        int n = -1;
        if (string != null) {
            n = proxyInfo.getPort();
        } else {
            string = proxyInfo.getSocksProxy();
            if (string != null) {
                n = proxyInfo.getSocksPort();
            } else {
                return true;
            }
        }
        String string2 = string;
        int n2 = n;
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this, string2, n2){
            private final String val$proxyHost;
            private final int val$proxyPort;
            private final SmartProxyHandler this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object[] objectArray = new Object[]{this.val$proxyHost, new Integer(this.val$proxyPort)};
                Socket socket = new Socket();
                Trace.msgNetPrintln("net.proxy.browser.smartConfig", objectArray);
                try {
                    socket.connect(new InetSocketAddress(this.val$proxyHost, this.val$proxyPort), SmartProxyHandler.access$000(this.this$0));
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                catch (Exception exception) {
                    Trace.msgNetPrintln("net.proxy.browser.connectionException", objectArray);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
                return Boolean.FALSE;
            }
            {
                this.this$0 = smartProxyHandler;
                this.val$proxyHost = string;
                this.val$proxyPort = n;
            }
        });
        return bl;
    }

    static int access$000(SmartProxyHandler smartProxyHandler) {
        return smartProxyHandler.pingTimeout;
    }

    static int access$002(SmartProxyHandler smartProxyHandler, int n) {
        smartProxyHandler.pingTimeout = n;
        return smartProxyHandler.pingTimeout;
    }

    static long access$102(SmartProxyHandler smartProxyHandler, long l) {
        smartProxyHandler.aliveTimeout = l;
        return smartProxyHandler.aliveTimeout;
    }

    static long access$202(SmartProxyHandler smartProxyHandler, long l) {
        smartProxyHandler.deadTimeout = l;
        return smartProxyHandler.deadTimeout;
    }

    public ProxyInfo[] getProxyInfo(URL uRL) throws ServiceUnavailableException {
        ProxyInfo[] proxyInfoArray = this.realHandler.getProxyInfo(uRL);
        for (int i = 0; i < proxyInfoArray.length; ++i) {
            String string = proxyInfoArray[i].toString();
            ProxyRecord proxyRecord = (ProxyRecord)this.proxyCache.get(string);
            if (proxyRecord == null) {
                ProxyRecord proxyRecord2 = new ProxyRecord(this, false, Calendar.getInstance().getTimeInMillis());
                this.proxyCache.put(string, proxyRecord2);
                if (!this.pingProxy(proxyInfoArray[i])) continue;
                proxyRecord2.setStatus(true);
                return new ProxyInfo[]{proxyInfoArray[i]};
            }
            long l = Calendar.getInstance().getTimeInMillis();
            boolean bl = proxyRecord.getStatus();
            long l2 = proxyRecord.getTimeStamp();
            if (l2 > 0L && (bl && l - l2 >= this.aliveTimeout || !bl && l - l2 >= this.deadTimeout)) {
                bl = this.pingProxy(proxyInfoArray[i]);
                proxyRecord.setTimeStamp(l);
                proxyRecord.setStatus(bl);
            }
            if (!bl) continue;
            return new ProxyInfo[]{proxyInfoArray[i]};
        }
        return new ProxyInfo[]{proxyInfoArray[0]};
    }

    private class ProxyRecord {
        private boolean isAlive;
        private long timeStamp;
        private final SmartProxyHandler this$0;

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public boolean getStatus() {
            return this.isAlive;
        }

        public void setTimeStamp(long l) {
            this.timeStamp = l;
        }

        public void setStatus(boolean bl) {
            this.isAlive = bl;
        }

        public ProxyRecord(SmartProxyHandler smartProxyHandler, boolean bl, long l) {
            this.this$0 = smartProxyHandler;
            this.isAlive = false;
            this.timeStamp = 0L;
            this.isAlive = bl;
            this.timeStamp = l;
        }
    }
}

